# Speed Delete - User Guide

> **Delete files & folders instantly.** No Recycle Bin. No recovery. Just gone.

---

## Quick Start

1. **Download** `SpeedDelete.exe`
2. **Double-click** to run (no installation needed)
3. **Drop files/folders** onto the app or click Browse
4. **Click DELETE** - done!

---

## Features

### ⚡ Fast Delete (FREE)
Instant deletion that bypasses the Recycle Bin. Files are removed immediately from your system.

### 🛡️ Forensic Removal (PRO)
Military-grade secure deletion. Your data is overwritten 3 times with random patterns before deletion, making it **impossible to recover** with any software or forensic tools.

**Use this for:**
- Sensitive documents
- Financial records
- Personal photos
- Client data
- Anything you want permanently destroyed

---

## FREE vs PRO

| Feature | FREE | PRO |
|---------|:----:|:---:|
| Fast Delete | ✅ | ✅ |
| Single file/folder deletion | ✅ | ✅ |
| Drag & drop (single item) | ✅ | ✅ |
| Progress tracking | ✅ | ✅ |
| Forensic Removal | 1 use | ✅ Unlimited |
| Multi-file selection | ❌ | ✅ |
| Multi-folder selection | ❌ | ✅ |
| Unlimited queue | ❌ | ✅ |
| Full deletion history | ❌ | ✅ |
| History search & filters | ❌ | ✅ |
| Export history (CSV/JSON) | ❌ | ✅ |

### Pricing
- **$5** - 3 Year License
- **$7** - Lifetime License (Best Value)

One-time payment. No subscription. No auto-renewal.

---

## How to Use

### Delete a Single Item
1. Click **📁 Folder** or **📄 File** button
2. Select what you want to delete
3. Review the size and file count
4. Click **DELETE PERMANENTLY**

### Delete Multiple Items (PRO)
1. Hold **Ctrl** or **Shift** while selecting
2. Or drag multiple items onto the app
3. Items are added to the queue
4. Click **DELETE ALL IN QUEUE**

### Use Forensic Removal
1. Click the **🛡️ Forensic Removal** mode button
2. The button turns purple when active
3. Delete as normal - data will be securely wiped

### View Deletion History
1. Click **View previous tasks** at the bottom
2. See what you've deleted, when, and how long it took
3. PRO users can search, filter, and export history

---

## Deletion Speed

Speed Delete is engineered to be **significantly faster than Windows Explorer** across all common storage types.

On modern systems, large folders that take minutes in Explorer are often removed in **seconds**.

Your actual results depend on your storage hardware and the structure of the files being deleted.

### 💾 Storage Performance Overview

| Storage Type | Performance | What to Expect |
|--------------|-------------|----------------|
| **NVMe SSD** | ⚡⚡⚡⚡⚡ | Near-instant deletion, even for very large folders |
| **SATA SSD** | ⚡⚡⚡⚡ | Extremely fast and responsive |
| **HDD (7200rpm)** | ⚡⚡⚡ | Strong performance, especially for large files |
| **HDD (5400rpm)** | ⚡⚡ | Noticeably faster than Explorer for most tasks |
| **USB 3.x Drives** | ⚡⚡⚡ | Excellent external performance |
| **USB 2.0 Drives** | ⚡⚡ | Still far faster than Explorer's delete process |
| **Network Drives** | ⚡⚡ | Performance depends on network speed and server load |

Even on older drives, Speed Delete consistently outperforms Windows Explorer by avoiding UI and Recycle Bin overhead.

### 📁 What Influences Deletion Performance

| Factor | Effect |
|--------|--------|
| **Local drive deletion** | Maximum speed |
| **Folder structure** | Fewer large files delete faster than many tiny ones |
| **Storage technology** | Modern SSDs deliver instant results |
| **Drive condition** | Healthy drives perform best |
| **Forensic Removal mode** | Prioritizes data destruction over raw speed |

### 🚀 Why Speed Delete Feels Instant

Speed Delete removes file system entries directly.

It does **not**:
- Move files to the Recycle Bin
- Copy data elsewhere
- Recalculate folder size mid-operation
- Refresh the UI for every file
- Wait on shell extensions

Windows Explorer performs all of these steps, which is why it slows down or freezes during large deletions.

**Speed Delete skips the overhead entirely.**

That is why folders Explorer struggles with often disappear almost immediately here.

### ⚡ Performance Notes

- Fast Delete has no measurable impact on SSD lifespan
- Forensic Removal intentionally prioritizes secure overwriting
- External and network drives are limited by their connection speed
- High CPU or disk usage during deletion indicates maximum throughput

**Bonus:** Speed Delete supports long paths beyond Windows Explorer's traditional 260-character limit, allowing it to remove deeply nested folders Explorer often fails to delete.

---

## Activation (PRO)

1. Purchase a license from our website
2. You'll receive a license key via email
3. In the app, click **⚡ Upgrade to PRO**
4. Enter your license key
5. Click **Activate**

Your license is tied to your computer. You can use it on **2 devices**.

Need to transfer? Contact support.

---

## FAQ

### Is this safe to use?
Yes. Speed Delete only deletes what you explicitly select. It will not delete system folders like Windows, Program Files, or Users root directories.

### Can I recover deleted files?
- **Fast Delete:** Possibly, with recovery software (until the disk space is overwritten)
- **Forensic Removal:** No. The data is destroyed beyond recovery.

### Why is Speed Delete so fast?
Speed Delete removes file system entries directly. It skips everything that makes Windows Explorer freeze during large deletions:

- No moving files to Recycle Bin
- No copying data elsewhere
- No recalculating folder sizes
- No refreshing UI for every file
- No waiting on shell extensions

That's why folders Explorer struggles with often disappear almost immediately here.

### Why is my antivirus flagging this?
Some antivirus software flags any app that performs direct file operations. Speed Delete is safe - it's a false positive. You can:
- Add an exception in your antivirus
- Check VirusTotal for verification

### Does this need admin rights?
No. Speed Delete runs without administrator privileges. It can only delete files you have permission to delete.

### Can I delete files in use?
No. If a file is open in another program, Windows locks it. Close the program first, then delete.

### Where is my license stored?
Your license is stored in: `%APPDATA%\speed-delete-electron\license.dat`

### What if I reinstall Windows?
Your license allows 2 activations. Just enter your key again after reinstalling.

### Is there a Mac or Linux version?
Not currently. Speed Delete is Windows-only (Windows 8, 10, 11).

---

## Keyboard Shortcuts

| Shortcut | Action |
|----------|--------|
| `Ctrl+O` | Browse for folder |
| `Ctrl+Shift+O` | Browse for file |
| `Delete` | Delete selected item |
| `Escape` | Cancel / Close modal |

---

## Troubleshooting

### "Access Denied" error
- The file may be in use by another program
- You may not have permission to delete it
- Try running Speed Delete as Administrator (right-click → Run as administrator)

### "File is in use" error
- Close any programs that might be using the file
- Check Task Manager for background processes
- Try again after a few seconds

### Optimizing deletion performance
- **Use local drives** when possible for maximum speed
- **USB 3.x ports** deliver better performance than USB 2.0
- **Forensic mode** prioritizes secure overwriting over raw speed
- **Large files** delete faster than many small files
- **Close other programs** to give Speed Delete maximum resources
- **Healthy drives** perform best - consider checking drive health if performance drops

### App won't start
- Make sure you're running Windows 8 or later
- Try running as Administrator
- Check if antivirus is blocking it

---

## Support

- **Website:** https://spdelete.com
- **Support Email:** support@spdelete.com
- **General Inquiries:** info@spdelete.com

---

## Legal

Speed Delete permanently destroys data. Use responsibly.

**We are not responsible for:**
- Accidental deletion of important files
- Data loss from user error
- Any damages resulting from use of this software

Always double-check before deleting. There is no undo.

---

*Speed Delete v1.0 | © 2025 Zidishops*
